<?php

namespace App\Modules\Passenger\Application\ReviewReport;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class PassengerReviewReportQuery implements Query
{
    public function __construct(
        private string $dateStart,
        private string $dateEnd,
        private $range,
        private int $uploadedMediaStatus,
        private $action
    ) {
    }

    public function dateStart(): string
    {
        return $this->dateStart;
    }
    public function dateEnd(): string
    {
        return $this->dateEnd;
    }
    public function range()
    {
        return $this->range;
    }
    public function uploadedMediaStatus(): int
    {
        return $this->uploadedMediaStatus;
    }
    public function action()
    {
        return $this->action;
    }
}
