<?php

namespace App\Modules\Passenger\Application\ReviewFromGroup;

use App\Modules\Group\Domain\IdGroup;
use App\Modules\Passenger\Domain\PassengerRepository;

final class FromGroupPassengerReviewer
{
    public function __construct(private PassengerRepository $repository)
    {
    }

    public function __invoke(IdGroup $idGroup)
    {
        $response = $this->repository->reviewFromGroup($idGroup);
        return $response['Response_Data'];
    }
}
