<?php

namespace App\Modules\Passenger\Application;

use App\Modules\Passenger\Domain\IdPassenger;
use App\Modules\Passenger\Domain\PassengerImageDocument1;
use App\Modules\Passenger\Domain\PassengerImageDocument2;
use App\Modules\Passenger\Domain\PassengerRepository;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\Shared\Domain\QueryList\ListInput;

class PassengerUpdateDocuments
{

    private PassengerRepository $repository;

    public function __construct(PassengerRepository $repository)
    {
        $this->repository = $repository;
    }

    public function __invoke(
        IdPassenger $idPassenger,
        PassengerImageDocument1 $passengerImageDocument1,
        PassengerImageDocument2 $passengerImageDocument2,
    ) {
        return $this->repository->updateDocuments(
            $idPassenger,
            $passengerImageDocument1,
            $passengerImageDocument2,
        );
    }
}
