<?php

namespace App\Modules\Passenger\Application;

use App\Modules\Passenger\Domain\PassengerSearchWithReviewRepository;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;

class PassengerSearchWithReviewAmount
{

    private PassengerSearchWithReviewRepository $repository;

    public function __construct(PassengerSearchWithReviewRepository $repository)
    {
        $this->repository = $repository;
    }

    public function __invoke(
        DateStart $dateStart,
        DateEnd $dateEnd,
        $range,
        $idGroup,
        $action
    ) {
        return $this->repository->amount(
            $dateStart,
            $dateEnd,
            $range,
            $idGroup,
            $action
        );
    }
}
