<?php

namespace App\Modules\Passenger\Application;

use App\Modules\Passenger\Domain\PassengerSearchWithReviewRepository;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\Shared\Domain\QueryList\ListInput;

class PassengerSearchWithReview
{

    private PassengerSearchWithReviewRepository $repository;

    public function __construct(PassengerSearchWithReviewRepository $repository)
    {
        $this->repository = $repository;
    }

    public function __invoke(
        DateStart $dateStart,
        DateEnd $dateEnd,
        $range,
        $idGroup,
        $action,
        ListInput $listInput,
        $paginated
    ) {
        return $this->repository->search(
            $dateStart,
            $dateEnd,
            $range,
            $idGroup,
            $action,
            $listInput,
            $paginated
        );
    }
}
