<?php

namespace App\Modules\Passenger\Application\GetServices;

use App\Modules\ProviderTypeProvider\Application\Index\PassengerServicesGetterResponse;
use App\Modules\ProviderTypeProvider\Domain\IdProviderTypeProvider;
use App\Modules\ProviderTypeProvider\Domain\ProviderTypeProviderRepository;

final class PassengerServicesGetter
{
    public function __construct(private ProviderTypeProviderRepository $repository)
    {
    }

    public function __invoke(IdProviderTypeProvider $idProviderTypeProvider): PassengerServicesGetterResponse
    {
        return new PassengerServicesGetterResponse($this->repository->index($idProviderTypeProvider));
    }
}
