<?php

namespace App\Modules\Passenger\Application\ExcelReviewReport;

use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class PassengerExcelReviewReportQueryHandler implements QueryHandler
{
    public function __construct(
        private PassengerReviewReporter $reporter
    ) {
    }

    public function __invoke(PassengerReviewReportQuery $query): PassengerReviewReportResponse
    {
        return $this->reporter->__invoke(
            new DateStart($query->dateStart()),
            new DateEnd($query->dateEnd()),
            $query->range(),
            $query->action()
        );
    }
}
