<?php

namespace App\Modules\Passenger\Application\Confirm;

use App\Modules\BookingTourPassenger\Application\ListByPassenger\BookingTourPassengerPassengerLister;
use App\Modules\Passenger\Domain\IdPassenger;
use App\Modules\Passenger\Domain\PassengerConfirmMessage;
use App\Modules\Passenger\Domain\PassengerRepository;
use Illuminate\Support\Facades\DB;

final class PassengerConfirmer
{
    public function __construct(
        private PassengerRepository $repository,
    ) {
    }

    public function __invoke(IdPassenger $idPassenger, PassengerConfirmMessage $confirmMessage): ConfirmPassengerResponse
    {
        return new ConfirmPassengerResponse($this->repository->confirm($idPassenger, $confirmMessage));
    }
}
