<?php

namespace App\Modules\Passenger\Application\Confirm;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class ConfirmPassengerQuery implements Query
{
    public function __construct(
        private string $id,
        private string $message
    ) {
    }

    public function id(): int
    {
        return $this->id;
    }

    public function message(): string
    {
        return $this->message;
    }
}
