<?php

namespace App\Modules\Package\Application\GetCampSchedule;

use App\Modules\HtlCampSchedule\Domain\Calendar;

class TourCamp
{

    public $htlCampSchedules = [];
    public Calendar $schedule;

    public function __construct(
        public $idCamp,
        public $htlCampAvailability,
        public $day
    ) {
    }

    public function generateSchedule($dateTimeStart, $dateTimeEnd)
    {
        $htlCampSchedules = new DataGroup($this->htlCampSchedules, 'HtlCampSchedule_DateSchedule');
        $this->schedule = new Calendar($dateTimeStart, $dateTimeEnd);
        $v = $this;
        $this->schedule->generate(function ($date) use ($htlCampSchedules, &$v) {
            $schedule = $htlCampSchedules->getObject($date);
            return (object)[
                'date'      => $date,
                'availabilityStatus' => true,
                'paxFree'   => $schedule ? $v->htlCampAvailability - $schedule->HtlCampSchedule_AmountUsage : $v->htlCampAvailability,
                'paxAmount' => $schedule ? $schedule->HtlCampSchedule_AmountUsage : 0,
                'paxMin'    => 0,
                'lock'      => 0
            ];
        });
    }
}
