<?php

namespace App\Modules\Media\Domain;

use App\Modules\Shared\Domain\ErrorDictionary;
use App\Modules\Shared\Exceptions\BasicRequestException;

class MediaNotAvailable extends BasicRequestException
{
    public function __construct()
    {
        parent::__construct(
            400,
            ErrorDictionary::ERRORS['INTERNAL']['MEDIA']['MEDIA_CREATE']['MEDIA_NOT_AVAILABLE'],
            'File not accepted'
        );
    }
}
