<?php

namespace App\Modules\Media\Application\Create;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class CreateMediaQuery implements Query
{
    public function __construct(
        private string $inputName,
        private string $storagePath,
        private bool $hasLarge
    ) {
    }

    public function inputName(): string
    {
        return $this->inputName;
    }

    public function storagePath(): string
    {
        return $this->storagePath;
    }

    public function hasLarge(): bool
    {
        return $this->hasLarge;
    }
}
