<?php

namespace App\Modules\LeadPassenger\Application\Update;

use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\Language\Domain\IdLanguage;
use App\Modules\Lead\Domain\IdLead;
use App\Modules\LeadBooking\Domain\IdLeadBooking;
use App\Modules\LeadPassenger\Domain\IdLeadPassenger;
use App\Modules\LeadPassenger\Domain\LeadPassenger;
use App\Modules\LeadPassenger\Domain\LeadPassengerDate;
use App\Modules\LeadPassenger\Domain\LeadPassengerDOB;
use App\Modules\LeadPassenger\Domain\LeadPassengerEmail;
use App\Modules\LeadPassenger\Domain\LeadPassengerExtras;
use App\Modules\LeadPassenger\Domain\LeadPassengerGender;
use App\Modules\LeadPassenger\Domain\LeadPassengerImgDocument1;
use App\Modules\LeadPassenger\Domain\LeadPassengerInfoStatus;
use App\Modules\LeadPassenger\Domain\LeadPassengerLastName;
use App\Modules\LeadPassenger\Domain\LeadPassengerName;
use App\Modules\LeadPassenger\Domain\LeadPassengerNoDocument;
use App\Modules\LeadPassenger\Domain\LeadPassengerPhone;
use App\Modules\LeadPassenger\Domain\LeadPassengerRestriction;
use App\Modules\LeadPassenger\Domain\LeadPassengerStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\TypeDocument\Domain\IdTypeDocument;
use App\Modules\TypeRate\Domain\IdTypeRate;
use App\Modules\UserCountry\Domain\IdUserCountry;

final class LeadPassengerUpdaterQueryHandler implements QueryHandler
{
    public function __construct(private LeadPassengerUpdater $updater)
    {
    }

    public function __invoke(LeadPassengerUpdaterQuery $query): LeadPassengerUpdaterResponse
    {
        $model = new LeadPassenger(
            new LeadPassengerName($query->name()),
            new LeadPassengerLastName($query->lastName()),
            new LeadPassengerEmail($query->email()),
            new LeadPassengerPhone($query->phone()),
            new LeadPassengerGender($query->gender()),
            new LeadPassengerDOB($query->dob()),
            new LeadPassengerNoDocument($query->noDocument()),
            new LeadPassengerRestriction($query->restriction()),
            new LeadPassengerExtras($query->extras()),
            new LeadPassengerImgDocument1($query->imgDocument1()),
            new LeadPassengerStatus($query->status()),
            new LeadPassengerInfoStatus($query->infoStatus()),
            new IdLeadBooking($query->idLeadBooking()),
            new IdTypeDocument($query->idTypeDocument()),
            new IdUserCountry($query->idUserCountry()),
            new IdTypeRate($query->idTypeRate()),
            new IdLeadPassenger($query->id()),
        );
        return $this->updater->__invoke($model);
    }
}
