<?php

namespace App\Modules\LeadBookingTourPassenger\Application\Update;

use App\Modules\LeadBookingTourPassenger\Application\Update\LeadBookingTourPassengerUpdaterResponse;
use App\Modules\LeadBookingTourPassenger\Domain\LeadBookingTourPassenger;
use App\Modules\LeadBookingTourPassenger\Domain\LeadBookingTourPassengerRepository;
use App\Modules\LeadBookingTourPassenger\Domain\UpdateLeadBookingTourPassenger;

final class LeadBookingTourPassengerUpdater
{
    public function __construct(private LeadBookingTourPassengerRepository $repository)
    {
    }

    public function __invoke(
        LeadBookingTourPassenger $leadBookingTourPassenger
    ): LeadBookingTourPassengerUpdaterResponse {
        return new LeadBookingTourPassengerUpdaterResponse($this->repository->update($leadBookingTourPassenger));
    }
}
