<?php

namespace App\Modules\LeadBooking\Application\Update;

use App\Modules\LeadBooking\Application\Update\LeadBookingUpdaterResponse;
use App\Modules\LeadBooking\Domain\LeadBooking;
use App\Modules\LeadBooking\Domain\LeadBookingRepository;

final class LeadBookingUpdater
{
    public function __construct(private LeadBookingRepository $repository)
    {
    }

    public function __invoke(LeadBooking $leadBooking): LeadBookingUpdaterResponse
    {
        return new LeadBookingUpdaterResponse($this->repository->update($leadBooking));
    }
}
