<?php

namespace App\Modules\Lead\Application\Update;

use App\Modules\Lead\Application\Update\LeadUpdaterResponse;
use App\Modules\Lead\Domain\Lead;
use App\Modules\Lead\Domain\LeadRepository;

final class LeadUpdater
{
    public function __construct(private LeadRepository $repository)
    {
    }

    public function __invoke(Lead $lead): LeadUpdaterResponse
    {
        return new LeadUpdaterResponse($this->repository->update($lead));
    }
}
