<?php

namespace App\Modules\Lead\Application\List;

use App\Modules\Lead\Application\List\LeadListerResponse;
use App\Modules\Lead\Domain\LeadRepository;

final class LeadLister
{
    public function __construct(private LeadRepository $repository)
    {
    }

    public function __invoke(string $action): LeadListerResponse
    {
        return new LeadListerResponse($this->repository->find($action));
    }
}
