<?php

namespace App\Modules\Lead\Application\Index;

use App\Modules\Lead\Domain\IdLead;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class LeadIndexerQueryHandler implements QueryHandler
{
    public function __construct(private LeadIndexer $inserter)
    {
    }

    public function __invoke(LeadIndexerQuery $query): LeadIndexerResponse
    {
        return $this->inserter->__invoke(new IdLead($query->getId()));
    }
}
