<?php

namespace App\Modules\HtlTypeRoomBed\Domain;

use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class IndexHtlTypeRoomBed implements StorageCriteria
{

    public function __construct(
        private IdHtlTypeRoomBed $id,
        private bool $lockInShare = false
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = HtlTypeRoomBed::select('`htrb`');

        return DB::select(
            "SELECT $select
            FROM `t_htl_type_room_bed` `htrb`
            WHERE `htrb`.`Id_HtlTypeRoomBed` = ?
            AND `htrb`.`HtlTypeRoomBed_Status` <> 0",
            [
                $this->id->value()
            ]
        );
    }

    protected function analize($data)
    {
        if (!count($data)) {
            throw new HtlTypeRoomBedNotFound();
        }
        return $data[0];
    }
}
