<?php

namespace App\Modules\HtlTypeRoomBed\Domain;

use App\Modules\HtlBed\Domain\IdHtlBed;
use App\Modules\HtlCamp\Domain\IdHtlCamp;
use App\Modules\HtlTypeRoom\Domain\IdHtlTypeRoom;
use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;

class HtlTypeRoomBed extends AggregateRoot
{


    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('id', IdHtlTypeRoomBed::class, 'Id_HtlTypeRoomBed', 'primary'),
            new AggregateAttribute('status', HtlTypeRoomBedStatus::class, 'HtlTypeRoomBed_Status'),
            new AggregateAttribute('idHtlTypeRoom', IdHtlTypeRoom::class, 'Id_HtlTypeRoom'),
            new AggregateAttribute('idHtlBed', IdHtlBed::class, 'Id_HtlBed'),
        ];
    }

    protected static function table(): string
    {
        return 't_htl_type_room_bed';
    }

    public function __construct(
        protected IdHtlTypeRoomBed $id,
        protected HtlTypeRoomBedStatus $status,
        protected IdHtlTypeRoom $idHtlTypeRoom,
        protected IdHtlBed $idHtlBed
    ) {
    }

    public function id(): IdHtlTypeRoomBed
    {
        return $this->id;
    }

    public function status(): HtlTypeRoomBedStatus
    {
        return $this->status;
    }

    public function idHtlTypeRoom(): IdHtlTypeRoom
    {
        return $this->idHtlTypeRoom;
    }

    public function idHtlBed(): IdHtlBed
    {
        return $this->idHtlBed;
    }

    public function setStatus(HtlTypeRoomBedStatus $status): void
    {
        $this->status = $status;
    }

    public function delete()
    {
        $this->status = new HtlTypeRoomBedStatus(HtlTypeRoomBedStatus::DELETED);
    }
}
