<?php

namespace App\Modules\HtlTypeRoomBed\Application\Index;

use App\Modules\HtlTypeRoomBed\Application\HtlTypeRoomBedResponse;
use App\Modules\HtlTypeRoomBed\Domain\IdHtlTypeRoomBed;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class IndexHtlTypeRoomBedQueryHandler implements QueryHandler
{
    public function __construct(private HtlTypeRoomBedIndexer $inserter)
    {
    }

    public function __invoke(IndexHtlTypeRoomBedQuery $query): HtlTypeRoomBedResponse
    {
        $model = $this->inserter->__invoke(new IdHtlTypeRoomBed($query->getId()));
        return new HtlTypeRoomBedResponse(
            $model->id()->value(),
            $model->status()->value(),
            $model->idHtlTypeRoom()->value(),
            $model->idHtlBed()->value(),
        );
    }
}
