<?php

namespace App\Modules\HtlTypeRoomBed\Application\Create;

use App\Modules\HtlBed\Domain\IdHtlBed;
use App\Modules\HtlTypeRoomBed\Domain\IdHtlTypeRoomBed;
use App\Modules\HtlTypeRoomBed\Domain\HtlTypeRoomBed;
use App\Modules\HtlTypeRoomBed\Domain\HtlTypeRoomBedName;
use App\Modules\HtlTypeRoomBed\Domain\HtlTypeRoomBedStatus;
use App\Modules\HtlTypeRoomBed\Domain\HtlTypeRoomBedAvailability;
use App\Modules\HtlTypeRoomBed\Domain\HtlTypeRoomBedDescription;
use App\Modules\HtlCamp\Domain\IdHtlCamp;
use App\Modules\HtlTypeRoom\Domain\IdHtlTypeRoom;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class CreateHtlTypeRoomBedQueryHandler implements QueryHandler
{
    public function __construct(private HtlTypeRoomBedCreator $creator)
    {
    }

    public function __invoke(CreateHtlTypeRoomBedQuery $query): CreateHtlTypeRoomBedResponse
    {
        $model = new HtlTypeRoomBed(
            new IdHtlTypeRoomBed(0),
            new HtlTypeRoomBedStatus($query->status()),
            new IdHtlTypeRoom($query->idHtlTypeRoom()),
            new IdHtlBed($query->idHtlBed()),
        );
        return new CreateHtlTypeRoomBedResponse($this->creator->__invoke($model));
    }
}
