<?php

namespace App\Modules\HtlRoom\Application;

use App\Modules\HtlRoom\Application\UpdateAvailability\UpdateAvailabilityHtlRoomQuery;
use App\Modules\HtlRoom\Domain\HtlRoomRepository;
use App\Modules\HtlRoom\Domain\InsertHtlRoom;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class HtlRoomInserter
{

    public function __construct(
        private HtlRoomRepository $repository,
        private QueryBus $queryBus
    ) {
    }

    public function __invoke(InsertHtlRoom $htlRoom)
    {
        $response = $this->repository->insert($htlRoom);
        $this->queryBus->ask(new UpdateAvailabilityHtlRoomQuery($response['Response_Data']['Id']));
        return $response;
    }
}
