<?php

namespace App\Modules\HtlCampSchedule\Application\Update;

use App\Modules\HtlCampSchedule\Application\Index\HtlCampScheduleIndexer;
use App\Modules\HtlCampSchedule\Domain\IdHtlCampSchedule;
use App\Modules\HtlCampSchedule\Domain\HtlCampScheduleAbrv;
use App\Modules\HtlCampSchedule\Domain\HtlCampScheduleAmountUsage;
use App\Modules\HtlCampSchedule\Domain\HtlCampScheduleAvailability;
use App\Modules\HtlCampSchedule\Domain\HtlCampScheduleDate;
use App\Modules\HtlCampSchedule\Domain\HtlCampScheduleDateSchedule;
use App\Modules\HtlCampSchedule\Domain\HtlCampScheduleFromCamp;
use App\Modules\HtlCampSchedule\Domain\HtlCampScheduleLock;
use App\Modules\HtlCampSchedule\Domain\HtlCampScheduleName;
use App\Modules\HtlCampSchedule\Domain\HtlCampScheduleStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class UpdateHtlCampScheduleQueryHandler implements QueryHandler
{
    public function __construct(
        private HtlCampScheduleUpdater $updater,
        private HtlCampScheduleIndexer $indexer
    ) {
    }

    public function __invoke(UpdateHtlCampScheduleQuery $query): UpdateHtlCampScheduleResponse
    {
        $index = $this->indexer->__invoke(new IdHtlCampSchedule($query->id()), true);
        $index->setDate(new HtlCampScheduleDate($query->date()));
        $index->setDateSchedule(new HtlCampScheduleDateSchedule($query->dateSchedule()));
        $index->setFromCamp(new HtlCampScheduleFromCamp($query->fromCamp()));
        $index->setAvailability(new HtlCampScheduleAvailability($query->availability()));
        $index->setAmountUsage(new HtlCampScheduleAmountUsage($query->amountUsage()));
        $index->setLock(new HtlCampScheduleLock($query->lock()));
        $this->updater->__invoke($index);
        return new UpdateHtlCampScheduleResponse();
    }
}
