<?php

namespace App\Modules\HtlCampSchedule\Application\OrderList;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class OrderListHtlCampScheduleQuery implements Query
{
    public function __construct(
        private string $DateTimeStart,
        private string $DateTimeEnd,
        private array $htlCampSchedule,
        private object $htlCamp
    ) {
    }

    public function getDateTimeStart()
    {
        return $this->DateTimeStart;
    }

    public function getDateTimeEnd()
    {
        return $this->DateTimeEnd;
    }

    public function getHtlCampSchedule()
    {
        return $this->htlCampSchedule;
    }

    public function getHtlCamp()
    {
        return $this->htlCamp;
    }
}
