<?php

namespace App\Modules\HtlCampSchedule\Application\List;

use App\Modules\HtlCamp\Domain\IdHtlCamp;
use App\Modules\HtlCampSchedule\Domain\HtlCampScheduleListModel;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\Shared\Domain\DateTimeEnd;
use App\Modules\Shared\Domain\DateTimeStart;

final class ListHtlCampScheduleQueryHandler implements QueryHandler
{
    public function __construct(private HtlCampScheduleLister $lister)
    {
    }

    public function __invoke(ListHtlCampScheduleQuery $query): ListHtlCampScheduleResponses
    {
        return new ListHtlCampScheduleResponses(...array_map(
            fn (HtlCampScheduleListModel $index) => new ListHtlCampScheduleResponse(
                $index->id()->value(),
                $index->date()->value(),
                $index->dateSchedule()->value(),
                $index->fromCamp()->value(),
                $index->availability()->value(),
                $index->amountUsage()->value(),
                $index->lock()->value(),
                $index->idHtlCamp()->value(),
                $index->htlCampBooking()->value()
            ),
            $this->lister->__invoke(
                new IdHtlCamp($query->getIdHtlCamp()),
                new DateTimeStart($query->getDateTimeStart()),
                new DateTimeEnd($query->getDateTimeEnd())
            )
        ));
    }
}
