<?php

namespace App\Modules\HtlCampSchedule\Application\Index;

use App\Modules\HtlCampSchedule\Application\HtlCampScheduleResponse;
use App\Modules\HtlCampSchedule\Domain\IdHtlCampSchedule;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class IndexHtlCampScheduleQueryHandler implements QueryHandler
{
    public function __construct(private HtlCampScheduleIndexer $inserter)
    {
    }

    public function __invoke(IndexHtlCampScheduleQuery $query): HtlCampScheduleResponse
    {
        $model = $this->inserter->__invoke(new IdHtlCampSchedule($query->getId()));
        return new HtlCampScheduleResponse(
            $model->id()->value(),
            $model->date()->value(),
            $model->dateSchedule()->value(),
            $model->fromCamp()->value(),
            $model->availability()->value(),
            $model->amountUsage()->value(),
            $model->lock()->value(),
            $model->idHtlCamp()->value()
        );
    }
}
