<?php

namespace App\Modules\HtlCampSchedule\Application\ChangeUsage;

use App\Modules\HtlCamp\Domain\IdHtlCamp;
use App\Modules\HtlCampSchedule\Application\Availability\HtlCampScheduleAvailabilityFinder;
use App\Modules\HtlCampSchedule\Application\HtlCampScheduleResponse;
use App\Modules\HtlCampSchedule\Domain\HtlCampScheduleDateSchedule;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ChangeUsageHtlCampScheduleQueryHandler implements QueryHandler
{
    public function __construct(
        private HtlCampScheduleAvailabilityFinder $availabilityFinder,
        private HtlCampScheduleUsageChanger $usageChanger,
    ) {
    }

    public function __invoke(ChangeUsageHtlCampScheduleQuery $query)
    {
        $model = $this->availabilityFinder->__invoke(
            new IdHtlCamp($query->getIdHtlCamp()),
            new HtlCampScheduleDateSchedule($query->getDate())
        );
        return $this->usageChanger->__invoke($model, $query->getAmountBefore(), $query->getAmountAfter());
    }
}
