<?php

namespace App\Modules\HtlCampSchedule\Application\Availability;

use App\Modules\HtlCamp\Domain\IdHtlCamp;
use App\Modules\HtlCampSchedule\Application\HtlCampScheduleResponse;
use App\Modules\HtlCampSchedule\Domain\HtlCampScheduleDateSchedule;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\Shared\Exceptions\InvalidRequestException;

final class AvailabilityHtlCampScheduleQueryHandler implements QueryHandler
{
    public function __construct(private HtlCampScheduleAvailabilityFinder $availabilityFinder)
    {
    }

    public function __invoke(AvailabilityHtlCampScheduleQuery $query): HtlCampScheduleResponse
    {
        $model = $this->availabilityFinder->__invoke(
            new IdHtlCamp($query->getIdHtlCamp()),
            new HtlCampScheduleDateSchedule($query->getDateSchedule())
        );
        return new HtlCampScheduleResponse(
            $model->id()->value(),
            $model->date()->value(),
            $model->dateSchedule()->value(),
            $model->fromCamp()->value(),
            $model->availability()->value(),
            $model->amountUsage()->value(),
            $model->lock()->value(),
            $model->idHtlCamp()->value()
        );
    }
}
