<?php

namespace App\Modules\HtlCampSchedule\Application\AddUsage;

use App\Modules\HtlCamp\Domain\IdHtlCamp;
use App\Modules\HtlCampSchedule\Application\Availability\HtlCampScheduleAvailabilityFinder;
use App\Modules\HtlCampSchedule\Application\HtlCampScheduleResponse;
use App\Modules\HtlCampSchedule\Domain\HtlCampScheduleDateSchedule;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class AddUsageHtlCampScheduleQueryHandler implements QueryHandler
{
    public function __construct(
        private HtlCampScheduleAvailabilityFinder $availabilityFinder,
        private HtlCampScheduleUsageAdder $usageAdder,
    ) {
    }

    public function __invoke(AddUsageHtlCampScheduleQuery $query)
    {
        $model = $this->availabilityFinder->__invoke(
            new IdHtlCamp($query->getIdHtlCamp()),
            new HtlCampScheduleDateSchedule($query->getDate())
        );
        return $this->usageAdder->__invoke($model, $query->getAmount());
    }
}
