<?php

namespace App\Modules\HtlCampBookingPassenger\Domain;

use App\Modules\BookingTourPassenger\Domain\BookingTourPassengerStatus;
use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\HtlCampBooking\Domain\IdHtlCampBooking;
use App\Modules\Passenger\Domain\PassengerLastName;
use App\Modules\Passenger\Domain\PassengerName;
use App\Modules\Passenger\Domain\PassengerOrder;
use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;

class ListHtlCampBookingPassengerModel extends AggregateRoot
{


    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('id', IdHtlCampBookingPassenger::class, 'Id_HtlCampBookingPassenger', 'primary'),
            new AggregateAttribute('weight', HtlCampBookingPassengerWeight::class, 'HtlCampBookingPassenger_Weight'),
            new AggregateAttribute('status', HtlCampBookingPassengerStatus::class, 'HtlCampBookingPassenger_Status'),
            new AggregateAttribute('idHtlCampBooking', IdHtlCampBooking::class, 'Id_HtlCampBooking'),
            new AggregateAttribute('idBookingTourPassenger', IdBookingTourPassenger::class, 'Id_BookingTourPassenger'),
            new AggregateAttribute('bookingTourPassengerStatus', BookingTourPassengerStatus::class, 'BookingTourPassenger_Status'),
            new AggregateAttribute('passengerName', PassengerName::class, 'Passenger_Name'),
            new AggregateAttribute('passengerLastName', PassengerLastName::class, 'Passenger_LastName'),
            new AggregateAttribute('passengerOrder', PassengerOrder::class, 'Passenger_Order'),
        ];
    }

    protected static function table(): string
    {
        return 't_htl_camp_booking_passenger';
    }

    public function __construct(
        protected IdHtlCampBookingPassenger $id,
        protected HtlCampBookingPassengerWeight $weight,
        protected HtlCampBookingPassengerStatus $status,
        protected IdHtlCampBooking $idHtlCampBooking,
        protected IdBookingTourPassenger $idBookingTourPassenger,
        protected BookingTourPassengerStatus $bookingTourPassengerStatus,
        protected PassengerName $passengerName,
        protected PassengerLastName $passengerLastName,
        protected PassengerOrder $passengerOrder,
    ) {
    }

    public function id(): IdHtlCampBookingPassenger
    {
        return $this->id;
    }

    public function weight(): HtlCampBookingPassengerWeight
    {
        return $this->weight;
    }

    public function status(): HtlCampBookingPassengerStatus
    {
        return $this->status;
    }

    public function idHtlCampBooking(): IdHtlCampBooking
    {
        return $this->idHtlCampBooking;
    }

    public function idBookingTourPassenger(): IdBookingTourPassenger
    {
        return $this->idBookingTourPassenger;
    }

    public function bookingTourPassengerStatus(): BookingTourPassengerStatus
    {
        return $this->bookingTourPassengerStatus;
    }

    public function passengerName(): PassengerName
    {
        return $this->passengerName;
    }

    public function passengerLastName(): PassengerLastName
    {
        return $this->passengerLastName;
    }

    public function passengerOrder(): PassengerOrder
    {
        return $this->passengerOrder;
    }

    public function setStatus(HtlCampBookingPassengerStatus $status): void
    {
        $this->status = $status;
    }
}
