<?php

namespace App\Modules\HtlCampBookingPassenger\Domain;

use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class IndexHtlCampBookingPassenger implements StorageCriteria
{

    public function __construct(
        private IdHtlCampBookingPassenger $id,
        private bool $lockInShare = false
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = HtlCampBookingPassenger::select('`hcb`');

        return DB::select(
            "SELECT $select
            FROM `t_htl_camp_booking_passenger` `hcb`
            WHERE `hcb`.`Id_HtlCampBookingPassenger` = ?",
            [
                $this->id->value()
            ]
        );
    }

    protected function analize($data)
    {
        if (!count($data)) {
            throw new HtlCampBookingPassengerNotFound();
        }
        return $data[0];
    }
}
