<?php

namespace App\Modules\HtlCampBookingPassenger\Application\ListByPassenger;

use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\HtlCampBookingPassenger\Domain\ListByPassengerHtlCampBookingPassengerModel;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ListByPassengerHtlCampBookingPassengerQueryHandler implements QueryHandler
{
    public function __construct(private ByPassengerHtlCampBookingPassengerLister $lister)
    {
    }

    public function __invoke(
        ListByPassengerHtlCampBookingPassengerQuery $query
    ): ListByPassengerHtlCampBookingPassengerResponses {
        return new ListByPassengerHtlCampBookingPassengerResponses(...array_map(
            fn (ListByPassengerHtlCampBookingPassengerModel $index) => new ListByPassengerHtlCampBookingPassengerResponse(
                $index->id()->value(),
                $index->weight()->value(),
                $index->status()->value(),
                $index->idHtlCampBooking()->value(),
                $index->idBookingTourPassenger()->value(),
                $index->date()->value(),
                $index->dateStart()->value(),
                $index->amount()->value(),
                $index->amountTotal()->value(),
                $index->campBookingStatus()->value(),
                $index->lock()->value(),
                $index->remark()->value(),
                $index->idHtlCampSchedule()->value(),
                $index->idBookingTour()->value(),
            ),
            $this->lister->__invoke(
                new IdBookingTourPassenger($query->getIdBookingTourPassenger()),
                $query->getAction()
            )
        ));
    }
}
