<?php

namespace App\Modules\HtlCampBookingPassenger\Application\Index;

use App\Modules\HtlCampBookingPassenger\Domain\IdHtlCampBookingPassenger;
use App\Modules\HtlCampBookingPassenger\Domain\HtlCampBookingPassengerRepository;
use App\Modules\HtlCampBookingPassenger\Domain\IndexHtlCampBookingPassenger;

final class HtlCampBookingPassengerIndexer
{
    public function __construct(private HtlCampBookingPassengerRepository $repository)
    {
    }

    public function __invoke(IdHtlCampBookingPassenger $idHtlCampBookingPassenger, bool $lockInShare = false)
    {
        $index = $this->repository->find(new IndexHtlCampBookingPassenger($idHtlCampBookingPassenger, $lockInShare));
        return $index;
    }
}
