<?php

namespace App\Modules\HtlCampBookingPassenger\Application\Create;

use App\Modules\HtlCampBooking\Application\Find\FindHtlCampBookingQuery;
use App\Modules\HtlCampBooking\Application\HtlCampBookingResponse;
use App\Modules\HtlCampBooking\Application\ReloadAmount\ReloadAmountHtlCampBookingQuery;
use App\Modules\HtlCampBookingPassenger\Domain\HtlCampBookingPassenger;
use App\Modules\HtlCampBookingPassenger\Domain\HtlCampBookingPassengerRepository;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

final class HtlCampBookingPassengerCreator
{
    public function __construct(
        private HtlCampBookingPassengerRepository $repository,
        private QueryBus $queryBus
    ) {
    }

    public function __invoke(HtlCampBookingPassenger $model)
    {
        /** @var HtlCampBookingResponse $exists */
        $exists = $this->queryBus->ask(new FindHtlCampBookingQuery($model->idHtlCampBooking()->value()));
        $response = $this->repository->insert($model);
        $this->queryBus->ask(new ReloadAmountHtlCampBookingQuery($model->idHtlCampBooking()->value()));
        return $response;
    }
}
