<?php

namespace App\Modules\HtlCampBookingPassenger\Application\Create;

use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\HtlCampBooking\Domain\IdHtlCampBooking;
use App\Modules\HtlCampBookingPassenger\Domain\IdHtlCampBookingPassenger;
use App\Modules\HtlCampBookingPassenger\Domain\HtlCampBookingPassenger;
use App\Modules\HtlCampBookingPassenger\Domain\HtlCampBookingPassengerStatus;
use App\Modules\HtlCampBookingPassenger\Domain\HtlCampBookingPassengerWeight;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class CreateHtlCampBookingPassengerQueryHandler implements QueryHandler
{
    public function __construct(private HtlCampBookingPassengerCreator $creator)
    {
    }

    public function __invoke(CreateHtlCampBookingPassengerQuery $query): CreateHtlCampBookingPassengerResponse
    {
        $model = new HtlCampBookingPassenger(
            new IdHtlCampBookingPassenger(0),
            new HtlCampBookingPassengerWeight($query->weight()),
            new HtlCampBookingPassengerStatus($query->status()),
            new IdHtlCampBooking($query->idHtlCampBooking()),
            new IdBookingTourPassenger($query->idBookingTourPassenger()),
        );
        return new CreateHtlCampBookingPassengerResponse($this->creator->__invoke($model));
    }
}
