<?php

namespace App\Modules\HtlCampBooking\Domain;

use App\Modules\BookingTour\Domain\IdBookingTour;
use App\Modules\HtlCampSchedule\Domain\IdHtlCampSchedule;
use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;

class HtlCampBooking extends AggregateRoot
{


    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('id', IdHtlCampBooking::class, 'Id_HtlCampBooking', 'primary'),
            new AggregateAttribute('date', HtlCampBookingDate::class, 'HtlCampBooking_Date'),
            new AggregateAttribute('dateStart', HtlCampBookingDateStart::class, 'HtlCampBooking_DateStart'),
            new AggregateAttribute('amount', HtlCampBookingAmount::class, 'HtlCampBooking_Amount'),
            new AggregateAttribute('amountTotal', HtlCampBookingAmountTotal::class, 'HtlCampBooking_AmountTotal'),
            new AggregateAttribute('status', HtlCampBookingStatus::class, 'HtlCampBooking_Status'),
            new AggregateAttribute('lock', HtlCampBookingLock::class, 'HtlCampBooking_Lock'),
            new AggregateAttribute('remark', HtlCampBookingRemark::class, 'HtlCampBooking_Remark'),
            new AggregateAttribute('idHtlCampSchedule', IdHtlCampSchedule::class, 'Id_HtlCampSchedule'),
            new AggregateAttribute('idBookingTour', IdBookingTour::class, 'Id_BookingTour'),
        ];
    }

    protected static function table(): string
    {
        return 't_htl_camp_booking';
    }

    public function __construct(
        protected IdHtlCampBooking $id,
        protected HtlCampBookingDate $date,
        protected HtlCampBookingDateStart $dateStart,
        protected HtlCampBookingAmount $amount,
        protected HtlCampBookingAmountTotal $amountTotal,
        protected HtlCampBookingStatus $status,
        protected HtlCampBookingLock $lock,
        protected HtlCampBookingRemark $remark,
        protected IdHtlCampSchedule $idHtlCampSchedule,
        protected IdBookingTour $idBookingTour
    ) {
    }

    public function id(): IdHtlCampBooking
    {
        return $this->id;
    }

    public function date(): HtlCampBookingDate
    {
        return $this->date;
    }

    public function dateStart(): HtlCampBookingDateStart
    {
        return $this->dateStart;
    }

    public function amount(): HtlCampBookingAmount
    {
        return $this->amount;
    }

    public function amountTotal(): HtlCampBookingAmountTotal
    {
        return $this->amountTotal;
    }

    public function status(): HtlCampBookingStatus
    {
        return $this->status;
    }

    public function lock(): HtlCampBookingLock
    {
        return $this->lock;
    }

    public function remark(): HtlCampBookingRemark
    {
        return $this->remark;
    }

    public function idHtlCampSchedule(): IdHtlCampSchedule
    {
        return $this->idHtlCampSchedule;
    }

    public function idBookingTour(): IdBookingTour
    {
        return $this->idBookingTour;
    }

    public function isLocked(): bool
    {
        return $this->lock->value() === HtlCampBookingLock::activeValue();
    }

    public function setDate(HtlCampBookingDate $date): void
    {
        $this->date = $date;
    }

    public function setDateStart(HtlCampBookingDateStart $dateStart): void
    {
        $this->dateStart = $dateStart;
    }

    public function setLock(HtlCampBookingLock $lock): void
    {
        $this->lock = $lock;
    }

    public function setAmount(HtlCampBookingAmount $amount): void
    {
        $this->amount = $amount;
    }

    public function setAmountTotal(HtlCampBookingAmountTotal $amountTotal): void
    {
        $this->amountTotal = $amountTotal;
    }

    public function setStatus(HtlCampBookingStatus $status): void
    {
        $this->status = $status;
    }

    public function setRemark(HtlCampBookingRemark $remark): void
    {
        $this->remark = $remark;
    }

    public function setIdHtlCampSchedule(IdHtlCampSchedule $idHtlCampSchedule): void
    {
        $this->idHtlCampSchedule = $idHtlCampSchedule;
    }

    public function delete()
    {
        $this->status = HtlCampBookingStatus::deletedValue();
    }

    public static function generatePassenger(
        HtlCampBookingDateStart $dateStart,
        HtlCampBookingAmount $amount,
        IdHtlCampSchedule $idHtlCampSchedule,
        IdBookingTour $idBookingTour
    ) {
        return new HtlCampBooking(
            new IdHtlCampBooking(0),
            HtlCampBookingDate::now(),
            $dateStart,
            $amount,
            new HtlCampBookingAmountTotal($amount->value()),
            HtlCampBookingStatus::defaultValue(),
            HtlCampBookingLock::activeValue(),
            HtlCampBookingRemark::defaultValue(),
            $idHtlCampSchedule,
            $idBookingTour
        );
    }
}
