<?php

namespace App\Modules\HtlCampBooking\Domain;

use App\Modules\BookingTour\Domain\IdBookingTour;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class DuplicateHtlCampBooking implements StorageCriteria
{

    public function __construct(
        private IdHtlCampBooking $id,
        private HtlCampBookingDateStart $dateStart,
        private IdBookingTour $idBookingTour,
        private bool $lockInShare = false
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = HtlCampBooking::select('`hcb`');
        $lockInShare = $this->lockInShare ? 'LOCK IN SHARE MODE' : '';

        return DB::select(
            "SELECT $select
            FROM `t_htl_camp_booking` `hcb`
            WHERE
                CASE
                    WHEN ? = 0 THEN
                        `HtlCampBooking_DateStart` = ? AND
                        `Id_BookingTour` = ?
                    WHEN ? <> 0 THEN
                        `HtlCampBooking_DateStart` = ? AND
                        `Id_BookingTour` = ? AND
                        `Id_HtlCampBooking` <> ?
                END
                AND `HtlCampBooking_Status` > 0
                LIMIT 1
                $lockInShare",
            [
                $this->id->value(),
                $this->dateStart->value(),
                $this->idBookingTour->value(),
                $this->id->value(),
                $this->dateStart->value(),
                $this->idBookingTour->value(),
                $this->id->value()
            ]
        );
    }

    protected function analize($data)
    {
        if (count($data)) {
            throw new HtlCampBookingDuplicated();
        }
        return [];
    }
}
