<?php

namespace App\Modules\HtlCampBooking\Application\UpdateStatus;

use App\Modules\HtlCampBooking\Application\Index\HtlCampBookingIndexer;
use App\Modules\HtlCampBooking\Domain\HtlCampBookingAmount;
use App\Modules\HtlCampBooking\Domain\IdHtlCampBooking;
use App\Modules\HtlCampBooking\Domain\HtlCampBookingDate;
use App\Modules\HtlCampBooking\Domain\HtlCampBookingDateStart;
use App\Modules\HtlCampBooking\Domain\HtlCampBookingLock;
use App\Modules\HtlCampBooking\Domain\HtlCampBookingRemark;
use App\Modules\HtlCampBooking\Domain\HtlCampBookingStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class UpdateStatusHtlCampBookingQueryHandler implements QueryHandler
{
    public function __construct(
        private HtlCampBookingStatusUpdater $updater,
        private HtlCampBookingIndexer $indexer
    ) {
    }

    public function __invoke(UpdateStatusHtlCampBookingQuery $query): UpdateStatusHtlCampBookingResponse
    {
        $index = $this->indexer->__invoke(new IdHtlCampBooking($query->id()), true);
        $index->setDate(new HtlCampBookingDate($query->date()));
        $index->setStatus(new HtlCampBookingStatus($query->status()));
        $index->setRemark(new HtlCampBookingRemark($query->remark()));
        $index->setLock(new HtlCampBookingLock($query->lock()));
        $this->updater->__invoke($index);
        return new UpdateStatusHtlCampBookingResponse();
    }
}
