<?php

namespace App\Modules\HtlCampBooking\Application\UpdateDateStart;

use App\Modules\HtlCampBooking\Application\Index\HtlCampBookingIndexer;
use App\Modules\HtlCampBooking\Domain\HtlCampBooking;
use App\Modules\HtlCampBooking\Domain\HtlCampBookingDateStart;
use App\Modules\HtlCampBooking\Domain\IdHtlCampBooking;
use App\Modules\HtlCampSchedule\Application\Availability\AvailabilityHtlCampScheduleQuery;
use App\Modules\HtlCampSchedule\Application\HtlCampScheduleResponse;
use App\Modules\HtlCampSchedule\Application\Index\IndexHtlCampScheduleQuery;
use App\Modules\HtlCampSchedule\Application\ReloadAmount\ReloadAmountHtlCampScheduleQuery;
use App\Modules\HtlCampSchedule\Domain\IdHtlCampSchedule;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class UpdateDateStartHtlCampBookingQueryHandler implements QueryHandler
{
    public function __construct(
        private HtlCampBookingDateStartUpdater $updater,
        private HtlCampBookingIndexer $indexer,
        private QueryBus $queryBus
    ) {}

    public function __invoke(UpdateDateStartHtlCampBookingQuery $query)
    {
        $index = $this->getIndex($query->id());
        $schedule = $this->getCurrentSchedule($index->idHtlCampSchedule()->value());
        $updated = $this->updateDateStart($index, $schedule->Id_HtlCamp, $query->dateStart());
        $this->changeUsage($schedule->Id_HtlCampSchedule);
        $this->changeUsage($index->idHtlCampSchedule()->value());
        return $updated;
    }

    private function getIndex(int $idHtlCampBooking)
    {
        return $this->indexer->__invoke(new IdHtlCampBooking($idHtlCampBooking), true);
    }

    private function getCurrentSchedule($idHtlCampSchedule): HtlCampScheduleResponse
    {
        return $this->queryBus->ask(new IndexHtlCampScheduleQuery($idHtlCampSchedule));
    }

    private function updateDateStart(HtlCampBooking $index, $idHtlCamp, $dateStart)
    {
        $index->setDateStart(new HtlCampBookingDateStart($dateStart));
        /** @var HtlCampScheduleResponse $availability */
        $availability = $this->queryBus->ask(new AvailabilityHtlCampScheduleQuery($idHtlCamp, $dateStart, 0));
        $index->setIdHtlCampSchedule(new IdHtlCampSchedule($availability->Id_HtlCampSchedule));
        return $this->updater->__invoke($index);
    }

    private function changeUsage($idHtlCampSchedule)
    {
        $this->queryBus->ask(new ReloadAmountHtlCampScheduleQuery($idHtlCampSchedule));
    }
}
