<?php

namespace App\Modules\HtlCampBooking\Application\List;

use App\Modules\BookingTour\Domain\IdBookingTour;
use App\Modules\HtlCampBooking\Domain\HtlCampBookingRepository;
use App\Modules\HtlCampBooking\Domain\ListHtlCampBooking;

final class HtlCampBookingLister
{
    public function __construct(private HtlCampBookingRepository $repository)
    {
    }

    public function __invoke(IdBookingTour $idBookingTour, string $action)
    {
        return $this->repository->search(new ListHtlCampBooking($idBookingTour, $action));
    }
}
