<?php

namespace App\Modules\HtlCampBooking\Application\Index;

use App\Modules\HtlCampBooking\Domain\IdHtlCampBooking;
use App\Modules\HtlCampBooking\Domain\HtlCampBookingRepository;
use App\Modules\HtlCampBooking\Domain\IndexHtlCampBooking;

final class HtlCampBookingIndexer
{
    public function __construct(private HtlCampBookingRepository $repository)
    {
    }

    public function __invoke(IdHtlCampBooking $idHtlCampBooking, bool $lockInShare = false)
    {
        $index = $this->repository->find(new IndexHtlCampBooking($idHtlCampBooking, $lockInShare));
        return $index;
    }
}
