<?php

namespace App\Modules\HtlCampBooking\Application\Find;

use App\Modules\HtlCampBooking\Domain\ExistsHtlCampBooking;
use App\Modules\HtlCampBooking\Domain\IdHtlCampBooking;
use App\Modules\HtlCampBooking\Domain\HtlCampBookingRepository;

final class HtlCampBookingFinder
{
    public function __construct(private HtlCampBookingRepository $repository)
    {
    }

    public function __invoke(IdHtlCampBooking $idHtlCampBooking, bool $lockInShare = true)
    {
        $index = $this->repository->find(new ExistsHtlCampBooking($idHtlCampBooking, $lockInShare));
        return $index;
    }
}
