<?php

namespace App\Modules\HtlBed\Application\List;

use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\HtlBed\Application\HtlBedResponse;
use App\Modules\HtlBed\Application\HtlBedResponses;
use App\Modules\HtlBed\Domain\HtlBed;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ListHtlBedQueryHandler implements QueryHandler
{
    public function __construct(private HtlBedLister $lister)
    {
    }

    public function __invoke(ListHtlBedQuery $query): HtlBedResponses
    {
        return new HtlBedResponses(...array_map(
            fn (HtlBed $index) => new HtlBedResponse(
                $index->id()->value(),
                $index->name()->value(),
                $index->description()->value(),
                $index->availability()->value(),
                $index->status()->value(),
                $index->idHtlCamp()->value(),
            ),
            $this->lister->__invoke($query->getAction())
        ));
    }
}
