<?php

namespace App\Modules\HtlBed\Application\Index;

use App\Modules\HtlBed\Domain\IdHtlBed;
use App\Modules\HtlBed\Domain\HtlBedRepository;
use App\Modules\HtlBed\Domain\IndexHtlBed;

final class HtlBedIndexer
{
    public function __construct(private HtlBedRepository $repository)
    {
    }

    public function __invoke(IdHtlBed $idHtlBed, bool $lockInShare = false)
    {
        $index = $this->repository->find(new IndexHtlBed($idHtlBed, $lockInShare));
        return $index;
    }
}
