<?php

namespace App\Modules\GroupProviderReview\Application\Update;

use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\GroupProvider\Domain\IdGroupProvider;
use App\Modules\GroupProviderReview\Domain\GroupProviderReviewAdminComment;
use App\Modules\GroupProviderReview\Domain\IdGroupProviderReview;
use App\Modules\GroupProviderReview\Domain\InsertGroupProviderReview;
use App\Modules\GroupProviderReview\Domain\UpdateGroupProviderReview;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\Question\Domain\IdQuestion;

final class UpdateGroupProviderReviewQueryHandler implements QueryHandler
{
    public function __construct(private GroupProviderReviewUpdater $updater)
    {
    }

    public function __invoke(UpdateGroupProviderReviewQuery $query): UpdateGroupProviderReviewResponse
    {
        $model = new UpdateGroupProviderReview(
            new IdGroupProviderReview($query->id()),
            new GroupProviderReviewAdminComment($query->adminComment()),
            new IdAdmin($query->adminCommentIdAdmin())
        );
        return $this->updater->__invoke($model);
    }
}
