<?php

namespace App\Modules\GroupProviderReview\Application\List;

use App\Modules\GroupProvider\Domain\IdGroupProvider;
use App\Modules\GroupProviderReview\Domain\GroupProviderReviewRepository;

final class GroupProviderReviewLister
{
    public function __construct(private GroupProviderReviewRepository $repository)
    {
    }

    public function __invoke(IdGroupProvider $idGroupProvider, string $action): GroupProviderReviewListerResponse
    {
        return new GroupProviderReviewListerResponse($this->repository->groupFind($idGroupProvider, $action));
    }
}
