<?php

namespace App\Modules\GroupProviderReview\Application\Create;

use App\Modules\GroupProvider\Domain\IdGroupProvider;
use App\Modules\GroupProviderReview\Domain\InsertGroupProviderReview;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\Question\Domain\IdQuestion;

final class GroupProviderReviewInserterQueryHandler implements QueryHandler
{
    public function __construct(private GroupProviderReviewInserter $inserter)
    {
    }

    public function __invoke(GroupProviderReviewInserterQuery $query): GroupProviderReviewInserterResponse
    {
        $model = new InsertGroupProviderReview(
            new IdGroupProvider($query->idGroupProvider()),
            new IdQuestion($query->idQuestion()),
        );
        return $this->inserter->__invoke($model);
    }
}
