<?php

namespace App\Modules\GroupProvider\Domain;

use App\Modules\Group\Domain\IdGroup;
use App\Modules\Provider\Domain\ProviderNoDocument;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;

interface GroupProviderRepository
{
    public function find(StorageCriteria $criteria);
    public function searchByDocument(IdGroup $idGroup, ProviderNoDocument $noDocument);
    public function searchByDocumentOnly(ProviderNoDocument $noDocument);
    public function mask(IdGroupProvider $id, GroupProviderMask $mask);
    public function list(IdGroup $idGroup);

    /**
     * @template T
     * @param StorageCriteria<T> $criteria
     * @return array<T>
     */
    public function search(StorageCriteria $criteria);
    public function updateModel(GroupProvider $value);
}
