<?php

namespace App\Modules\GroupProvider\Application\ListGallery;

use App\Modules\GroupProvider\Domain\GroupProvider;
use App\Modules\GroupProvider\Domain\IdGroupProvider;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\Shared\Domain\QueryList\QueryPaginate;

final class ListGalleryGroupProviderQueryHandler implements QueryHandler
{
    public function __construct(private GalleryGroupProviderLister $lister)
    {
    }

    public function __invoke(ListGalleryGroupProviderQuery $query)
    {
        return new ListGalleryGroupProviderResponses(...array_map(
            fn ($index) => new ListGalleryGroupProviderResponse(
                $index->Id_GroupProvider,
                $index->GroupProvider_Type,
                $index->GroupProvider_Remark,
                $index->GroupProvider_AnsweredReview,
                $index->GroupProvider_Mask,
                $index->GroupProvider_IsCloned,
                $index->GroupProvider_MediaDateUpdate,
                $index->GroupProvider_MediaStatus,
                $index->GroupProvider_MediaScore,
                $index->GroupProvider_MediaScoreDescription,
                $index->Id_Group,
                $index->Id_Provider,
                $index->Id_TypeProvider,
                $index->Id_StatusGroupProvider,
                new ListGalleryGroupProviderResponseProvider(
                    $index->Provider_BusinessName,
                    $index->Provider_TradeName,
                    $index->Provider_NickName,
                    $index->Provider_NoDocument,
                    $index->Provider_Address,
                    $index->Provider_Phone,
                    $index->Provider_ImgProfile,
                    $index->Provider_ImgProfile_Thumb,
                    $index->Provider_Score,
                    $index->Provider_ScoreTotal,
                    $index->Provider_NoScored,
                    $index->Provider_ScoreCant,
                    $index->Provider_Status,
                    $index->Id_TypeDocument,
                    $index->Id_Country,
                    $index->Id_State,
                    $index->Id_City,
                ),
                new ListGalleryGroupProviderResponseTypeProvider(
                    $index->TypeProvider_Name,
                    $index->TypeProvider_Abrv,
                    $index->TypeProvider_Endorser,
                    $index->TypeProvider_Lock,
                    $index->TypeProvider_Status,
                ),
                new ListGalleryGroupProviderResponseGroup(
                    $index->Group_Date,
                    $index->Group_DateUpdate,
                    $index->Group_DateStart,
                    $index->Group_DateEnd,
                    $index->Group_Hour,
                    $index->Group_Name,
                    $index->Group_Token,
                    $index->Group_Origin,
                    $index->Group_Destination,
                    $index->Group_Type,
                    $index->Group_Order,
                    $index->Group_TourDuration,
                    $index->Group_Remark,
                    $index->Group_MasterType,
                    $index->Group_ServiceType,
                    $index->Group_NoValidPassengers,
                    $index->Group_ValidPassengers,
                    $index->Group_Status,
                    $index->Id_Master,
                    $index->Id_Service,
                    $index->Id_StatusGroup,
                    $index->Id_Tour === null ? null : new ListGalleryGroupProviderResponseTour(
                        $index->Id_Tour,
                        $index->Tour_Code,
                        $index->Tour_Name,
                        $index->Tour_UrlThumbnail,
                        $index->Tour_Duration,
                        $index->Tour_MinPax,
                        $index->Tour_Availability,
                        $index->Tour_AvailabilityStatus,
                        $index->Tour_Anticipation,
                        $index->Tour_AnticipationType,
                        $index->Tour_Color,
                        $index->Tour_Score,
                        $index->Tour_ScoreCant,
                        $index->Tour_ScoreTotal,
                        $index->Tour_Status,
                        $index->Id_CategoryTour,
                        $index->Id_TypeTour,
                        $index->Id_Country,
                        $index->Id_State,
                        $index->Id_City,
                    )
                )
            ),
            $this->lister->__invoke(
                $query->dateStart(),
                $query->dateEnd(),
                $query->search(),
                $query->action(),
                QueryPaginate::fromData($query->page(), $query->pageSize()),
            )
        ));
    }
}
